require 'rubygems'
require 'page-object'
require 'page-object/page_factory'
require 'rspec'
require 'watir-webdriver'

RSpec.configure do |c|
  # declare an exclusion filter
  #c.filter_run_excluding :broken => true
  c.filter_run_excluding :regression => true
  c.filter_run_excluding :acceptance => true
  c.filter_run_excluding :smoketest => true
  c.filter_run_excluding :archived => true
  c.filter_run_excluding :broken => true
end

RSpec.configure do |config|

  fetch_current_example = RSpec.respond_to?(:current_example) ? proc { RSpec.current_example } : proc { |context| context.example }

  config.include PageObject::PageFactory

  config.after(:each) do
    example = fetch_current_example.call(self);

    if example.exception
      meta = example.metadata
      filename = File.basename(meta[:file_path])
      line_number = meta[:line_number]
      buildJobUrl = ENV["JOB_URL"]
      buildJobNumber = ENV["BUILD_NUMBER"]
      screenshot_name = "screenshot-#{filename}-#{line_number}.png"
      screenshot_dir = "screenshots" + (buildJobNumber != nil ? ("_" + buildJobNumber.to_s) : "")
      screenshot_path = screenshot_dir + "/#{screenshot_name}"


      if !Dir.exists?(screenshot_dir)
        Dir.mkdir screenshot_dir
      end

      @driver.screenshot.save screenshot_path
      puts "----Test Failed @ URL =>  " + @driver.url
      puts "----Screenshot ------------------------------------------------------------------------"
      puts meta[:full_description] + "\n  Screenshot: #{screenshot_path}\n  " + (buildJobUrl != nil ? buildJobUrl.to_s : "") + "/ws/veteran-appointment-requests/test/watir-ruby/" + screenshot_path
      puts "---------------------------------------------------------------------------------------"
    end
  end

end

VAR_BASE_URL = ENV['VAR_BASE_URL'] || "http://localhost:8089/var/v4/"
VAR_SERVICE_URL = ENV['VAR_SERVICE_URL'] || "http://localhost:8089/"
MONGO_PORT = ENV['MONGO_PORT'] || "27017"
MONGO_URL = "mongodb://localhost:#{MONGO_PORT}/"
MONGO_VMM_URI = ENV['MONGO_VMM_URI'] || "mongodb://vmm:vmm@localhost:27017/vmm?"

ORACLE_USER = ENV['ORACLE_USER'] || "VARDB"
ORACLE_PASSWORD = ENV['ORACLE_PASSWORD'] || "PW_Redacted   "
ORACLE_VAMF_HOST_PORT= ENV['ORACLE_VAMF_HOST_PORT'] || "//localhost:1521"
ORACLE_SERVICE_NAME = ENV['ORACLE_SERVICE_NAME'] || "xe"


MockUser = {"username" => "pw_redacted", "password" => "pass"}
MockUserSingleDFN={"username" => "zztest.patientten", "password" => "pass"}

TIME_OUT_LIMIT = 45

#App Static variables
PRIMARY_CARE = "Primary Care"
AUDIOLOGY = "Audiology"
OPTOMETRY = "Optometry"
MENTAL_HEALTH = "Outpatient Mental Health"
EXPRESS_CARE = "Express Care"

#Common Methods
def verifyErrorMessage (errorMessage)
  Watir::Wait.until {@error.errorSummaryHeader_element.exists?}
  Watir::Wait.until {@error.errorSummaryHeader_element.text == "The following errors were found:"}

  @error.errorSummaryHeader_element.when_visible
  expect(@error.errorSummaryHeader_element.text).to eq("The following errors were found:")
#  expect(@error.getFocusedElement() == @error.errorSummaryHeader_element).to eq(true)
  expect(@error.isErrorMsgDisplayed?(errorMessage)).to eq(true)
end

def compareContents(expected_content, actual_content)
  expected_content.each_with_index do |expectedScreenRow, i|
    expect(actual_content[i].to_s.strip).to include(expectedScreenRow.to_s.strip)
  end
end

pw_redacted = {"username" => "pw_redacted", "password" => "pass", "userid" => "1006088937V099668", "edipi" => "1113138327"}
MockUser02 = {"username" => "MockUser02", "password" => "pass", "userid" => "1013599714"}
MockUser03 = {"username" => "mockuser03", "password" => "pass", "userid" => "5000000345V879"}
MockUser05 = {"username" => "mockuser05", "password" => "pass", "userid" => "5000000348V765"}
MockUser09 = {"username" => "mockuser09", "password" => "pass", "userid" => "5000000360V672"}
MockUser10 = {"username" => "mockuser10", "password" => "pass", "userid" => "5000000361V612"}
VarPatient14 = {"username" => "zztest.patient14", "password" => "pass", "userid" => "0000000014"}
VarVeteran01 = {"username" => "zztest.veteran01", "password" => "pass", "userid" => "1244420300"}










